<?php
function sanitize_filename($name) {
    return preg_replace('/[^A-Za-z0-9_\-]/', '_', $name);
}
function is_allowed_image($file) {
    return in_array(mime_content_type($file['tmp_name']), ['image/jpeg','image/png']);
}
function escape($str) {
    return htmlspecialchars($str, ENT_QUOTES | ENT_HTML5, 'UTF-8');
}
function user_has_rated($pdo, $photo_id, $ip, $session_id) {
    $stmt = $pdo->prepare('SELECT COUNT(*) FROM ratings WHERE photo_id=? AND (rater_ip=? OR session_id=?)');
    $stmt->execute([$photo_id, $ip, $session_id]);
    return $stmt->fetchColumn() > 0;
}
?>